package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 * 定时扫描 到底显示时间，但是显示状态为【未显示】的评论 将其设置为【显示】
 */
@Component
@Slf4j
public class NewsReplySyncTask extends AbstractCronTask<String> {

    @Resource
    private NewsQuartzService newsQuartzService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("扫描新闻评论表");
        newsQuartzService.scanningNewsReply();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "newsReplySyncTask";
    }

    @Override
    public String cron() {
        return "0 0/5 * * * ?";
    }

    @Override
    public String description() {
        return "扫描新闻评论表";
    }

}
