package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 创建即发布的周期定时任务
 * 在指定时间，计算跟用户有关的评论，并且提醒用户回复
 */
@Component
@Slf4j
public class StatisticalPostReplyTask extends AbstractCronTask<String> {

    @Autowired
    private NewNewsReplyService newNewsReplyService;

    @Override
    protected ReturnT<String> service(String param) {
        newNewsReplyService.statisticalPostReply();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "statisticalPostReplyTask";
    }

    @Override
    public String cron() {
        return "0 0 9,12,18,21 * * ? ";
    }

    @Override
    public String description() {
        return "动态评论回复提醒";
    }

}
