package com.bxm.localnews.news.task;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.vo.TranscodeMap;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 创建即发布的周期定时任务
 * 视频转码，主要是为了视频由于编码原因无法播放
 */
@Component
@Slf4j
public class VideoTranscodeReplaceTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostFacadeService forumPostFacadeService;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Override
    protected ReturnT<String> service(String param) {
        log.info(".....................................视频转码地址定时替换 begin...................................");
        //获取执行队列的内容
        List<TranscodeMap> transcodeMapList = new ArrayList<>();
        Long size = redisListAdapter.size(RedisConfig.VIDEO_TRANSCODE_MAP_EXEC);
        while (size != null && size > 0) {
            TranscodeMap transcodeMap = redisListAdapter.rightPop(RedisConfig.VIDEO_TRANSCODE_MAP_EXEC, TranscodeMap.class);
            transcodeMapList.add(transcodeMap);
            size--;
        }

        //若执行队列非空，则开始执行其中内容
        if (CollectionUtils.isNotEmpty(transcodeMapList)) {
            log.info("开始处理转码替换地址，共[{}]条数据", transcodeMapList.size());
            forumPostFacadeService.batchUpdatePostVideo(transcodeMapList);
        }

        //将待处理缓存中的内容移动至执行缓存，在下次定时任务执行时处理
        size = redisListAdapter.size(RedisConfig.VIDEO_TRANSCODE_MAP);
        while (size != null && size > 0) {
            TranscodeMap transcodeMap = redisListAdapter.rightPop(RedisConfig.VIDEO_TRANSCODE_MAP, TranscodeMap.class);
            redisListAdapter.leftPush(RedisConfig.VIDEO_TRANSCODE_MAP_EXEC, transcodeMap);
            size--;
        }

        log.info(".....................................视频转码地址定时替换 end...................................");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "videoTranscodeReplaceTask";
    }

    @Override
    public String cron() {
        return "10 0/1 * * * ? ";
    }

    @Override
    public String description() {
        return "视频转码地址定时替换任务";
    }

}
