package com.bxm.localnews.news.util;

import com.bxm.newidea.component.oss.service.AliyunOSSService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.net.URLDecoder;

/**
 * 上传工具类
 *
 * @author stephen
 */
@Slf4j
@Component
public class UploadUtils {

    @Resource
    private AliyunOSSService aliyunOSSService;

    /**
     * 将图片上传至oss
     * @param src 图片地址
     * @return oss地址
     */
    public String uploadImgToOssBySrc(String src) {
        final RestTemplate template = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<Resource> httpEntity = new HttpEntity<>(headers);
        try {
            src = URLDecoder.decode(src, "UTF-8");
            log.debug("src:[{}]", src);
            ResponseEntity<byte[]> response = template.exchange(src, HttpMethod.GET, httpEntity, byte[].class);
            int i = src.lastIndexOf("/");
            String fileName = src.substring(i + 1);
            fileName = RandomStringUtils.random(8, true, false) + fileName;
            return aliyunOSSService.upload(response.getBody(), fileName);
        } catch (Exception e) {
            log.error("第三方图片上传出错", e);
        }
        return null;
    }

}
