package com.bxm.localnews.payment.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.bxm.localnews.payment.config.AlipayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.service.PayProxyService;
import com.bxm.newidea.component.controller.BaseController;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.google.common.collect.Maps;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zhaoyadong 2018/12/27 20:16
 * @desc
 */
@Api(tags = " 支付回调相关接口", description = "包括支付回调接口操作")
@ApiIgnore
@RestController
@RequestMapping("/api/notify")
@RefreshScope
public class PayNotifyController extends BaseController {

    private PayProxyService payProxyService;

    private AlipayProperties alipayProperties;

    @Autowired
    public PayNotifyController(PayProxyService payProxyService, AlipayProperties alipayProperties) {
        this.payProxyService = payProxyService;
        this.alipayProperties = alipayProperties;
    }

    @ApiOperation(value = "微信支付回调通知处理", notes = "")
    @PostMapping("/wechat")
    public String parseOrderNotifyResult(@RequestBody String xmlData) {
        //WxPayOrderNotifyResult notifyResult = this.wxProxyService.parseOrderNotifyResult(xmlData);
        // TODO 根据自己业务场景需要构造返回对象
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "支付宝回调通知处理", notes = "")
    @PostMapping("/alipay")
    public void aliPayNotifyResult(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();

            if (verifyResult(request)) {
                logger.info("支付回调通知验证成功");
                payProxyService.notifyPay(mapToString(request), PayTypeEnum.ALI_PAY);
                writer.print("success");
            } else {
                logger.info("支付宝回调通知验证失败");
                writer.print("fail");
            }
        } catch (AlipayApiException e) {
            logger.error("支付宝回调通知：数据解析异常: {}", e);
        } catch (IOException ioe) {
            logger.error("response获取writer异常:{}", ioe);
        }
    }

    /**
     * request里的map转成json字符串处理
     *
     * @return
     */
    private String mapToString(HttpServletRequest request) {
        try {
            Map<String, String> map = Maps.newHashMap();
            //商户订单号
            String outTradeNo = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");

            //交易状态
            String tradeStatus = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
            map.put("outTradeNo", outTradeNo);
            map.put("tradeStatus", tradeStatus);

            String notifyTime = new String(request.getParameter("notify_time").getBytes("ISO-8859-1"), "UTF-8");
            map.put("notifyTime", notifyTime);
            return JSONObject.toJSONString(map);
        } catch (UnsupportedEncodingException e) {
            logger.error("编码格式转换异常: {}", e);
        }

        return null;
    }

    /**
     * request提取参数
     *
     * @param request
     * @return
     */
    private Map<String, String> covertMap(HttpServletRequest request) {
        Map<String, String> map = Maps.newHashMap();
        Map requestParams = request.getParameterMap();
        for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext(); ) {
            String name = (String) iter.next();
            String[] values = (String[]) requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; i++) {
                valueStr = (i == values.length - 1) ? valueStr + values[i]
                        : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }
        logger.info("支付宝异步通知返回信息：{}", JSONObject.toJSONString(map));
        return map;
    }

    /**
     * 支付宝通知验证结果
     *
     * @param request
     * @return
     */
    private Boolean verifyResult(HttpServletRequest request) throws AlipayApiException {
        return AlipaySignature.rsaCheckV1(covertMap(request), alipayProperties.getAlipayPublicKey(),
                alipayProperties.getCharset(), alipayProperties.getSigntype());
    }
}
