package com.bxm.localnews.payment.controller;

import com.bxm.localnews.payment.param.AlipayAccountBindingParam;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liujia
 * @date 2020-08-04 21:13
 **/
@RestController
@AllArgsConstructor
@Api(tags = "6-04 支付宝信息绑定")
@RequestMapping("{version}/payment/aliapy")
public class AliypayController {

    private final PaymentWithdrawAccountService paymentWithdrawAccountService;

    @ApiOperation(value = "6-04-1 绑定支付宝账号", notes = "初始化绑定和变更均使用此接口")
    @PostMapping("binding")
    @ApiVersion(1)
    public ResponseJson<Boolean> binding(@RequestBody @Validated AlipayAccountBindingParam param) {
        Message message = paymentWithdrawAccountService.bindOrUpdateAlipayAccount(param);
        if (!message.isSuccess()) {
            return ResponseJson.badReqeuset(message.getLastMessage()).body(false);
        }
        return ResponseJson.ok(Boolean.TRUE);
    }
}
