package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.order.PaymentOrderFactory;
import com.bxm.localnews.payment.param.MerchantWithdrawParam;
import com.bxm.localnews.payment.param.RefundParam;
import com.bxm.localnews.payment.param.UserOrderFacadeParam;
import com.bxm.localnews.payment.pay.WithdrawProxySerivce;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Optional;

/**
 * @author pf.w
 * @date 2020/8/31 14:11
 **/
@Api(tags = "6-91 支付相关接口")
@RestController
@RequestMapping("facade/withdraw/payment")
@Slf4j
@AllArgsConstructor
public class PaymentFacadeController {

    private final PaymentWithdrawAccountService paymentWithdrawAccountService;

    private final PaymentOrderFactory paymentOrderFactory;

    private final WithdrawProxySerivce withdrawProxySerivce;

    @ApiOperation(value = "6-91-01 支付相关账号信息", notes = "支付相关账号信息")
    @GetMapping("/paymentAccount")
    public ResponseEntity<WithdrawAccountVO> paymentAccount(@RequestParam("type") Byte type, @RequestParam("userId") Long userId){
        Optional<WithdrawAccountVO> account =  paymentWithdrawAccountService.getPaymentAccount(type,userId);
        return account.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.ok(new WithdrawAccountVO()));
    }

    @ApiOperation(value = "6-91-02 创建预付订单", notes = "根据订单信息创建支付订单返回 供内部使用 如用户点击下单，" +
            "订单模块生成订单之后，调用当前接口生成支付信息")
    @PostMapping("order/create")
    public ResponseJson<PaymentOrderDTO> createPayOrder(@Valid @RequestBody UserOrderFacadeParam param) {
        return ResponseJson.ok(paymentOrderFactory.build(param));
    }

    @ApiOperation(value = "6-91-03 发起退款", notes = "根据支付流水单号发起退款 供商户模块使用 商家在同意订单退款时调用当前接口")
    @PostMapping("refund")
    public ResponseEntity<Message> refund(@RequestBody RefundParam param){
        return ResponseEntity.ok(paymentOrderFactory.submitRefund(param));
    }

    @ApiOperation(value = "6-91-04 商户提现打款", notes = "根据请求的账号信息，直接给对应的支付宝账号 or 微信账号打款")
    @PostMapping("merchantWithdraw")
    public ResponseEntity<Message> merchantWithdraw(@RequestBody @Validated MerchantWithdrawParam param){
        return ResponseEntity.ok(withdrawProxySerivce.merchantWithdraw(param));
    }


}
