package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.dto.WithdrawDTO;
import com.bxm.localnews.payment.order.PaymentOrderFactory;
import com.bxm.localnews.payment.param.PayRefundParam;
import com.bxm.localnews.payment.pay.WithdrawProxySerivce;
import com.bxm.localnews.payment.service.UserWithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

@Api(tags = "6-90 [内部接口]微信提现相关接口")
@RestController
@RequestMapping("facade/withdraw/manage")
@Slf4j
public class WithdrawFacadeController {

    @Autowired
    private WithdrawProxySerivce withdrawProxySerivce;

    @Autowired
    private UserWithdrawService userWithdrawService;


    @Autowired
    private PaymentOrderFactory paymentOrderFactory;


    @ApiOperation(value = "6-90-1 用户提现", notes = "用户直接提现")
    @PostMapping("")
    public Message withdraw(@RequestBody WithdrawFlow withdrawFlow) {
        //提现之前需要判断订单状态
        return withdrawProxySerivce.withdraw(withdrawFlow);
    }

    @ApiOperation(value = "6-90-2 企业付款相关查询", notes = "查询有问题的订单--并做相应的处理")
    @GetMapping("")
    public ResponseEntity<Message> queryWithdraw(@RequestBody WithdrawFlow withdrawFlow) {
        return ResponseEntity.ok(withdrawProxySerivce.queryWithdraw(withdrawFlow));
    }

    @ApiOperation(value = "6-90-3 小程序用户提现", notes = "小程序用户直接提现")
    @PostMapping("/applet")
    public ResponseEntity<Message> appletWithdraw(@RequestParam("userId") Long userId,
                                                  @RequestParam("openId") String openId,
                                                  @RequestParam("amount") BigDecimal amount,
                                                  @RequestParam("devcId") String devcId,
                                                  @RequestParam("ip") String ip) {
        return ResponseEntity.ok(userWithdrawService.appletUserWithdraw(userId, openId, amount, devcId, ip));
    }

    @ApiOperation(value = "6-90-4 获取提现配置", notes = "兼容历史接口，从用户模块迁移的配置信息")
    @GetMapping("/config/withdraw")
    public ResponseEntity<WithdrawDTO> getWithdrawDto(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(userWithdrawService.getWithdrawOptions(userId));
    }

    @RequestMapping(value = "/submitRefund", method = RequestMethod.POST)
    public ResponseJson<Message> submitRefund(@RequestBody PayRefundParam payRefundParam) {
        return ResponseJson.ok(paymentOrderFactory.submitRefund(payRefundParam));
    }
}
