/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.bxm.localnews.payment.config.AlipayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.order.PaymentOrderFactory;
import com.bxm.localnews.payment.pay.PayProxyService;
import com.bxm.localnews.payment.request.AlipayNotifyResult;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.util.WebUtils;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"6-02 \u652f\u4ed8\u56de\u8c03\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ec\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u64cd\u4f5c")
@ApiIgnore
@RestController
@RequestMapping(value={"/api/notify"})
public class PayNotifyController
extends BaseController {
    private PayProxyService payProxyService;
    private AlipayProperties alipayProperties;
    private final PaymentOrderFactory paymentOrderFactory;

    @Autowired
    public PayNotifyController(PayProxyService payProxyService, AlipayProperties alipayProperties, PaymentOrderFactory paymentOrderFactory) {
        this.payProxyService = payProxyService;
        this.alipayProperties = alipayProperties;
        this.paymentOrderFactory = paymentOrderFactory;
    }

    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5904\u7406", notes="")
    @PostMapping(value={"/wechat"})
    public String parseOrderNotifyResult(@RequestBody String xmlData) {
        String result = this.payProxyService.notifyPay(xmlData, PayTypeEnum.WX_PAY);
        if (result == null) {
            return WxPayNotifyResponse.fail((String)"FAIL");
        }
        return WxPayNotifyResponse.success((String)"SUCCESS");
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406", notes="")
    @PostMapping(value={"/alipay"})
    public void aliPayNotifyResult(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            if (this.alipayProperties.isEnableCallbackValid() && !this.verifyResult(request).booleanValue()) {
                this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u9a8c\u8bc1\u5931\u8d25,\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)WebUtils.getReqeustParam((HttpServletRequest)request));
                writer.print("fail");
                return;
            }
            AlipayNotifyResult result = this.parseReqeust(request);
            String jsonResult = JSON.toJSONString((Object)result);
            this.logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)jsonResult);
            this.payProxyService.notifyPay(jsonResult, PayTypeEnum.ALI_PAY);
            writer.print("success");
        }
        catch (AlipayApiException e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\uff1a\u6570\u636e\u89e3\u6790\u5f02\u5e38: {}", (Throwable)e);
        }
        catch (IOException ioe) {
            this.logger.error("response\u83b7\u53d6writer\u5f02\u5e38:{}", (Throwable)ioe);
        }
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406(\u9884\u53d1\u5e03\u73af\u5883\u652f\u6301\u7528)")
    @PostMapping(value={"pre/alipay"})
    public void alipayNodifyPreResult(HttpServletRequest request, HttpServletResponse response) {
        this.aliPayNotifyResult(request, response);
    }

    private AlipayNotifyResult parseReqeust(HttpServletRequest request) {
        return AlipayNotifyResult.builder().outTradeNo(this.getField("out_trade_no", request)).tradeStatus(this.getField("trade_status", request)).notifyTime(this.getField("notify_time", request)).tradeNo(this.getField("trade_no", request)).build();
    }

    private String getField(String fieldName, HttpServletRequest request) {
        return new String(request.getParameter(fieldName).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    private Map<String, String> covertMap(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)map));
        return map;
    }

    private Boolean verifyResult(HttpServletRequest request) throws AlipayApiException {
        return AlipaySignature.rsaCheckV1(this.covertMap(request), (String)this.alipayProperties.getAlipayPublicKey(), (String)this.alipayProperties.getCharset(), (String)this.alipayProperties.getSigntype());
    }

    @RequestMapping(value={"/wx/refund"}, method={RequestMethod.POST})
    public String refund(@RequestBody String xml) {
        return this.paymentOrderFactory.execRefundCallback(xml, PayTypeEnum.WX_PAY);
    }
}

