package com.bxm.localnews.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/12/28 10:52
 * @desc
 */
@ApiModel(description = "订单信息")
public class OrderStatusDTO {

    @ApiModelProperty("订单编号")
    private String paymentNum;

    @ApiModelProperty(value = "订单状态", notes = "1:待付款,2:取消付款,3:付款成功,4:付款失败,5:支付超时")
    private Byte status;

    public OrderStatusDTO(String paymentNum, Byte status) {
        this.paymentNum = paymentNum;
        this.status = status;
    }

    public String getPaymentNum() {
        return paymentNum;
    }

    public void setPaymentNum(String paymentNum) {
        this.paymentNum = paymentNum;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }
}
