package com.bxm.localnews.payment.vo;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zhaoyadong 2018/12/27 21:12
 * @desc
 */
public class PaymentOrder {

    /**
     * id
     */
    private Long id;

    /**
     * 订单编号
     */
    private String paymentNum;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 付款状态(1:待付款,2:取消付款,3:付款成功,4:付款失败,5:支付超时)
     */
    private Byte status;

    /**
     * 发起付款时间
     */
    private Date startTime;

    /**
     * 结束付款时间
     */
    private Date finishTime;

    /**
     * 付款金额
     */
    private BigDecimal amount;

    /**
     * 支付类型（1：微信，2：支付宝）
     */
    private Byte payType;

    /**
     * 发起支付的用户ID
     */
    private Long userId;

    /**
     * 支付反馈结果
     */
    private String result;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPaymentNum() {
        return paymentNum;
    }

    public void setPaymentNum(String paymentNum) {
        this.paymentNum = paymentNum;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Byte getPayType() {
        return payType;
    }

    public void setPayType(Byte payType) {
        this.payType = payType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}
