/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.bxm.localnews.payment.config.AlipayProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AlipayProperties.class})
public class AliPayConfiguration {
    private AlipayProperties alipayProperties;

    public AliPayConfiguration(AlipayProperties alipayProperties) {
        this.alipayProperties = alipayProperties;
    }

    @Bean(value={"alipayClient"})
    @RefreshScope
    public AlipayClient alipayClient() {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.alipayProperties.getGateWayUrl(), this.alipayProperties.getAppId(), this.alipayProperties.getRsaPrivateKey(), this.alipayProperties.getFormat(), this.alipayProperties.getCharset(), this.alipayProperties.getAlipayPublicKey(), this.alipayProperties.getSigntype());
        return alipayClient;
    }
}

