package com.bxm.localnews.payment.config;

import java.math.BigDecimal;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/1/2 14:53
 * @desc
 */
@ConfigurationProperties("payment.pay")
@Component
public class PayProperties {

    /**
     * vip购买价格
     */
    private BigDecimal vipPrice;

    /**
     * vip标题
     */
    private String vipTitle;

    /**
     * vip描述
     */
    private String vipDesc;

    /**
     * 调试开关
     */
    private Boolean switchType = false;

    private BigDecimal miniAppLimitAmount;

    public BigDecimal getVipPrice() {
        return vipPrice;
    }

    public void setVipPrice(BigDecimal vipPrice) {
        this.vipPrice = vipPrice;
    }

    public String getVipTitle() {
        return vipTitle;
    }

    public void setVipTitle(String vipTitle) {
        this.vipTitle = vipTitle;
    }

    public String getVipDesc() {
        return vipDesc;
    }

    public void setVipDesc(String vipDesc) {
        this.vipDesc = vipDesc;
    }

    public Boolean getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Boolean switchType) {
        this.switchType = switchType;
    }

    public BigDecimal getMiniAppLimitAmount() {
        return miniAppLimitAmount;
    }

    public void setMiniAppLimitAmount(BigDecimal miniAppLimitAmount) {
        this.miniAppLimitAmount = miniAppLimitAmount;
    }
}
