package com.bxm.localnews.payment.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhaoyadong 2018/12/27 14:04
 * @desc
 */
@ConfigurationProperties("payment.weixin.pay")
public class WxPayProperties {

    /**
     * appId
     */
    private String appId;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 商户密钥
     */
    private String mchKey;

    /**
     * 证书路径
     */
    private String keyPath;

    /**
     * 微信支付回调地址
     */
    private String notifyUrl;

    /**
     * 支付场景信息
     */
    private String sceneInfo;

    /**
     * 商品描述
     */
    private String body;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 是否使用沙箱环境
     */
    private Boolean useSandbox = Boolean.FALSE;

    /**
     * 企业付款描述信息
     */
    private String desc;

    /**
     * 未实名认证返回消息
     */
    private String untFailMsg;

    private String otherFailMsg;

    /**
     * 小程序appId
     */
    private String appletAppId;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getMchKey() {
        return mchKey;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public String getKeyPath() {
        return keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getSceneInfo() {
        return sceneInfo;
    }

    public void setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public Boolean getUseSandbox() {
        return useSandbox;
    }

    public void setUseSandbox(Boolean useSandbox) {
        this.useSandbox = useSandbox;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUntFailMsg() {
        return untFailMsg;
    }

    public void setUntFailMsg(String untFailMsg) {
        this.untFailMsg = untFailMsg;
    }

    public String getOtherFailMsg() {
        return otherFailMsg;
    }

    public void setOtherFailMsg(String otherFailMsg) {
        this.otherFailMsg = otherFailMsg;
    }

    public String getAppletAppId() {
        return appletAppId;
    }

    public void setAppletAppId(String appletAppId) {
        this.appletAppId = appletAppId;
    }
}
