package com.bxm.localnews.payment.proxy;

import java.util.Collection;
import java.util.Map;

import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.service.WithdrawService;
import com.bxm.localnews.payment.service.impl.DefaultWithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;

import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/11 10:52
 * @desc
 */
@Component
public class WithdrawProxySerivce {

    private Map<String, WithdrawService> withdrawMap;

    private WithdrawService defaultWithdrawService = new DefaultWithdrawService();

    public String withdraw(WithdrawFlow withdrawFlow) {
        Message message = getService(WithdrawTypeEnum.getNameByChannel(withdrawFlow.getPayChannel()))
                .withdraw(withdrawFlow);
        return message.getLashMessaage();
    }

    public Message queryWithdraw(WithdrawFlow withdrawFlow) {
        Message message = getService(WithdrawTypeEnum.getNameByChannel(withdrawFlow.getPayChannel()))
                .queryWithdraw(withdrawFlow);
        return message;
    }

    /**
     * 获取提现方式对应的提现服务提供接口，如果没有配置服务则返回默认的支付服务接口
     *
     * @param withdrawType 提现方式
     * @return 提现服务提供接口
     */
    private WithdrawService getService(String withdrawType) {
        WithdrawService service = getWithdrawMap().get(withdrawType);

        if (service == null) {
            service = defaultWithdrawService;
        }

        return service;
    }

    /**
     * 从spring context中加载WithdrawService的子类，根据提现类型进行匹配
     *
     * @return 提现类型和对应提现方式服务提供类的map
     */
    private Map<String, WithdrawService> getWithdrawMap() {
        if (null == withdrawMap) {
            withdrawMap = Maps.newHashMap();
            Collection<WithdrawService> withdrawServices = SpringContextHolder.getBeans(WithdrawService.class);

            for (WithdrawService withdrawService : withdrawServices) {
                if (withdrawService.support() != null) {
                    withdrawMap.put(withdrawService.support().getName(), withdrawService);
                }
            }
        }

        return withdrawMap;
    }
}
