package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.config.WxPayProperties;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2018/12/27 21:10
 * @desc
 */
@Component
public class WxPayProxyService extends BaseService {

    private WxPayService wxPayService;

    private WxPayProperties wxPayProperties;

    @Autowired
    public WxPayProxyService(WxPayService wxPayService, WxPayProperties wxPayProperties) {
        this.wxPayService = wxPayService;
        this.wxPayProperties = wxPayProperties;
    }

    /**
     * 微信支付结果通知
     *
     * @param data
     * @return
     */
    public WxPayOrderNotifyResult parseOrderNotifyResult(String data) {
        try {
            return wxPayService.parseOrderNotifyResult(data);
        } catch (WxPayException e) {
            logger.error("微信支付回调异常:", e);
            return null;
        }
    }

    /**
     * 查询微信订单
     *
     * @param paymentNum
     * @return
     */
    public WxPayOrderQueryResult queryOrder(String paymentNum) {
        try {
            return wxPayService.queryOrder(null, paymentNum);
        } catch (WxPayException e) {
            logger.error("查询订单[{}]异常: [{}]", paymentNum, e);
            return null;
        }
    }

    /**
     * APP下单返回信息
     *
     * @param paymentOrder
     * @return
     */
    public WxPayAppOrderResult createOrder(PaymentOrderDetail paymentOrder) {
        try {
            WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = generateOrder(paymentOrder);
            return wxPayService.createOrder(wxPayUnifiedOrderRequest);

        } catch (WxPayException e) {
            logger.error("微信下单失败！订单号：{},原因:{}", paymentOrder.getPaymentNum(), e.getMessage());
            logger.error("下单异常：", e);
        }

        return null;
    }

    /**
     * 统一下单
     *
     * @param paymentOrder
     * @return
     */
    private WxPayUnifiedOrderRequest generateOrder(PaymentOrder paymentOrder) {
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(paymentOrder.getPaymentNum());
        wxPayUnifiedOrderRequest.setBody(wxPayProperties.getBody());
        wxPayUnifiedOrderRequest.setSceneInfo(wxPayProperties.getSceneInfo());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(paymentOrder.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(paymentOrder.getClientIp());

        return wxPayUnifiedOrderRequest;
    }
}
