package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.request.WxPayQueryWithdrawRequest;
import com.bxm.localnews.payment.request.WxPayWithdrawRequest;
import com.bxm.localnews.payment.result.QueryWithdrawResult;
import com.bxm.localnews.payment.result.WxWithdrawResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.thoughtworks.xstream.XStream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/11 20:38
 * @desc
 */
@Component
public class WxWithdrawProxyService extends WxPayServiceImpl {

    @Autowired
    private WxPayService wxPayService;

    @Override
    public byte[] postForBytes(String url, String requestStr, boolean useKey) throws WxPayException {
        return new byte[0];
    }

    @Override
    public String post(String url, String requestStr, boolean useKey) throws WxPayException {
        return null;
    }

    /**
     * 提现
     *
     * @param request
     * @throws WxPayException
     */
    public WxWithdrawResult transfers(WxPayWithdrawRequest request) throws WxPayException {
        request.checkAndSign(wxPayService.getConfig());
        String url = wxPayService.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
        String responseContent = wxPayService.post(url, request.toXML(), Boolean.TRUE);

        XStream xstream = new XStream();
        XStream.setupDefaultSecurity(xstream);
        xstream.processAnnotations(WxWithdrawResult.class);
        xstream.allowTypes(new Class[]{WxWithdrawResult.class});
        WxWithdrawResult wxWithdrawResult = (WxWithdrawResult) xstream.fromXML(responseContent);
        return wxWithdrawResult;
    }

    /**
     * 查询企业付款
     *
     * @param request
     * @return
     * @throws WxPayException
     */
    public QueryWithdrawResult queryWithdraw(WxPayQueryWithdrawRequest request) throws WxPayException {
        request.checkAndSign(wxPayService.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = super.post(url, request.toXML(), Boolean.TRUE);

        XStream xstream = new XStream();
        XStream.setupDefaultSecurity(xstream);
        xstream.processAnnotations(QueryWithdrawResult.class);
        xstream.allowTypes(new Class[]{QueryWithdrawResult.class});
        QueryWithdrawResult queryWithdrawResult = (QueryWithdrawResult) xstream.fromXML(responseContent);
        return queryWithdrawResult;
    }
}
