package com.bxm.localnews.payment.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhaoyadong 2019/3/28 17:19
 * @desc
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@XStreamAlias("xml")
public class QueryWithdrawResult extends BaseWxPayResult {

    /**
     * 商户订单号
     * 商户订单号，需保持唯一性
     * (只能是字母或者数字，不能包含有其他字符)
     */
    @XStreamAlias("partner_trade_no")
    private String partnerTradeNo;

    /**
     * 微信产生的付款单号
     */
    @XStreamAlias("detail_id")
    private String detailId;

    /**
     * 转账状态
     */
    @XStreamAlias("status")
    private String status;

    /**
     * 失败原因
     */
    @XStreamAlias("reason")
    private String reason;

    /**
     * 收款用户openid
     */
    @XStreamAlias("openid")
    private String openId;

    /**
     * 收款用户姓名
     */
    @XStreamAlias("transfer_name")
    private String transferName;

    /**
     * 付款金额
     */
    @XStreamAlias("payment_amount")
    private Integer paymentAmount;

    /**
     * 付款成功时间
     */
    @XStreamAlias("payment_time")
    private String paymentTime;

    /**
     * 企业付款备注
     */
    @XStreamAlias("desc")
    private String desc;
}
