package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.payment.proxy.WxPayProxyService;
import com.bxm.localnews.payment.service.PayModeService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.gexin.fastjson.JSON;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/1/2 11:18
 * @desc
 */
@Component
public class WechatPayModeService extends BaseService implements PayModeService {


    @Autowired
    private RedPacketFacadeService redPacketFacadeService;

    @Autowired
    private WxPayProxyService wxPayProxyService;

    @Autowired
    private PayService payService;

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        WxPayAppOrderResult result = wxPayProxyService.createOrder(paymentOrderDetail);
        paymentOrderDetail.setLink(JSON.toJSONString(result));
    }

    @Override
    public void query(PaymentOrder paymentOrder) {
        WxPayOrderQueryResult result = wxPayProxyService.queryOrder(paymentOrder.getPaymentNum());

        if (!"SUCCESS".equals(result.getReturnCode()) ||
                !"SUCCESS".equals(result.getResultCode())) {
            logger.error("查询订单[{}]微信支付失败", paymentOrder.getPaymentNum());
            return;
        }

        if ("SUCCESS".equals(result.getTradeState())) {
            afterPaySucceed(result, paymentOrder);
        } else {
            afterPayClose(result, paymentOrder);
        }
    }

    @Override
    public String callBack(String data) {
        WxPayOrderNotifyResult result = wxPayProxyService.parseOrderNotifyResult(data);
        String paymentNum = result.getOutTradeNo();
        PaymentOrder paymentOrder = payService.getPaymentOrderByPaymentNo(paymentNum);
        if (paymentOrder == null) {
            logger.error("接收到的微信支付回调参数错误,支付订单[{}]不存在", paymentNum);
            return null;
        }

        Integer amount = BaseWxPayRequest.yuanToFen(paymentOrder.getAmount().toString());
        if (amount.intValue() != result.getTotalFee().intValue()) {
            logger.error("支付订单支付金额[{}]与微信返回的订单总金额[{}]不匹配", amount, result.getTotalFee());
            return null;
        }

        if (!"SUCCESS".equals(result.getReturnCode()) ||
                !"SUCCESS".equals(result.getResultCode())) {
            return null;
        }
        if (PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            query(paymentOrder);
        }

        if (!PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            logger.error("支付订单[{}]已处理，状态为：[{}]", paymentNum, paymentOrder.getStatus());
        }

        return "SUCCESS";
    }

    /**
     * 取消支付回调函数
     *
     * @param result       包含回调请求的相关信息
     * @param paymentOrder 需要更新的支付订单
     */
    private void afterPayClose(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict(result.getTimeEnd()));
        paymentOrder.setResult(result.getTradeState());
        payService.modifyPaymentOrderStatus(paymentOrder);
    }

    /**
     * 确认支付成功后的回调函数
     *
     * @param result       包含回调请求的相关信息
     * @param paymentOrder 需要更新的支付订单
     */
    private void afterPaySucceed(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.SUCCEED.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict(result.getTimeEnd()));
        paymentOrder.setResult(result.getErrCodeDes());
        payService.modifyPaymentOrderStatus(paymentOrder);
        redPacketFacadeService.updateRedpacketActiveStatus(paymentOrder.getBizId(),paymentOrder.getPaymentNum(),1);
    }
}
