/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.payment.param.PaymentOrderParam;
import com.bxm.localnews.payment.proxy.PayProxyService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    private PaymentOrderMapper paymentOrderMapper;
    private PayProxyService payProxyService;
    private SequenceCreater sequenceCreater;
    private RedisStringAdapter redisStringAdapter;
    private PayProperties payProperties;
    private VipFacadeService vipFacadeService;

    @Autowired
    public PayServiceImpl(PaymentOrderMapper paymentOrderMapper, PayProxyService payProxyService, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter, PayProperties payProperties, VipFacadeService vipFacadeService) {
        this.paymentOrderMapper = paymentOrderMapper;
        this.payProxyService = payProxyService;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
        this.payProperties = payProperties;
        this.vipFacadeService = vipFacadeService;
    }

    public PaymentOrderDTO addUserOrder(Long userId, Byte payType, String returnUrl) {
        if (this.vipFacadeService.checkUserActivatedVip(userId).booleanValue()) {
            return null;
        }
        this.updateUserPrePaymentOrder(userId);
        PaymentOrder paymentOrder = this.createOrder(userId, payType, null);
        this.paymentOrderMapper.insertSelective(paymentOrder);
        this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
        PaymentOrderDetail paymentOrderDetail = new PaymentOrderDetail();
        BeanUtils.copyProperties((Object)paymentOrder, (Object)paymentOrderDetail);
        paymentOrderDetail.setReturnUrl(returnUrl);
        this.payProxyService.create(paymentOrderDetail);
        return new PaymentOrderDTO(paymentOrderDetail.getLink(), paymentOrder.getPaymentNum());
    }

    public OrderStatusDTO queryOrder(String paymentNum) {
        return new OrderStatusDTO(paymentNum, this.getOrderStatus(paymentNum));
    }

    public Message modifyStatus(PaymentOrder paymentOrder) {
        Long bizId = this.vipFacadeService.addUserVipByPay(paymentOrder.getUserId());
        if (bizId == null) {
            return Message.build((boolean)Boolean.FALSE);
        }
        paymentOrder.setBizId(bizId);
        if (this.paymentOrderMapper.updateByPrimaryKey(paymentOrder) > 0) {
            this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
        }
        return Message.build();
    }

    public Message modifyPaymentOrderStatus(PaymentOrder paymentOrder) {
        if (this.paymentOrderMapper.updateByPrimaryKey(paymentOrder) > 0) {
            this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
        }
        return Message.build();
    }

    public PaymentOrder getPaymentOrderByPaymentNo(String paymentNum) {
        PaymentOrderParam param = new PaymentOrderParam();
        param.setPaymentNum(paymentNum);
        List paymentOrderList = this.paymentOrderMapper.selectUserOrder(param);
        if (CollectionUtils.isNotEmpty((Collection)paymentOrderList)) {
            return (PaymentOrder)paymentOrderList.get(0);
        }
        return null;
    }

    public PaymentOrderDTO createPayOrder(Long userId, Byte payType, BigDecimal amount, Long bizId, String ip) {
        this.updateUserPrePaymentOrder(userId);
        PaymentOrder paymentOrder = this.createOrder(userId, payType, amount);
        paymentOrder.setBizId(bizId);
        paymentOrder.setClientIp(ip);
        this.paymentOrderMapper.insertSelective(paymentOrder);
        this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
        PaymentOrderDetail paymentOrderDetail = new PaymentOrderDetail();
        BeanUtils.copyProperties((Object)paymentOrder, (Object)paymentOrderDetail);
        this.payProxyService.create(paymentOrderDetail);
        return new PaymentOrderDTO(paymentOrderDetail.getLink(), paymentOrder.getPaymentNum());
    }

    public OrderStatusDTO queryOrderStatus(String paymentNum, Byte payType) {
        PaymentOrder paymentOrder = this.getPaymentOrderByPaymentNo(paymentNum);
        if (PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.payProxyService.query(paymentOrder, PayTypeEnum.getPayTypeEnum(payType));
        }
        return new OrderStatusDTO(paymentNum, this.getOrderStatus(paymentNum));
    }

    private PaymentOrder createOrder(Long userId, Byte payType, BigDecimal amount) {
        PaymentOrder paymentOrder = new PaymentOrder();
        paymentOrder.setId(this.sequenceCreater.nextLongId());
        String paymentNum = this.generatePaymentNum(payType);
        paymentOrder.setPaymentNum(paymentNum);
        Date now = new Date();
        paymentOrder.setStatus(PaymentStatusEnum.WAIT.getType());
        paymentOrder.setStartTime(now);
        if (amount == null) {
            paymentOrder.setAmount(this.payProperties.getVipPrice());
        } else {
            paymentOrder.setAmount(amount);
        }
        paymentOrder.setPayType(payType);
        paymentOrder.setUserId(userId);
        paymentOrder.setCreateTime(now);
        return paymentOrder;
    }

    private String generatePaymentNum(Byte payType) {
        String prefix = PayTypeEnum.getNameByType(payType);
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private KeyGenerator getOrderStatusKey(String paymentNum) {
        return RedisConfig.WEIXIN_ORDER_STATUS.copy().appendKey((Object)paymentNum);
    }

    private Byte getOrderStatus(String paymentNum) {
        String status = this.redisStringAdapter.getString(this.getOrderStatusKey(paymentNum));
        if (StringUtils.isEmpty((CharSequence)status)) {
            PaymentOrder paymentOrder = this.getPaymentOrderByPaymentNo(paymentNum);
            if (paymentOrder == null) {
                return null;
            }
            this.redisStringAdapter.set(this.getOrderStatusKey(paymentNum), (Object)paymentOrder.getStatus(), 86400L);
            return paymentOrder.getStatus();
        }
        return Byte.valueOf(status);
    }

    private void updateUserPrePaymentOrder(Long userId) {
        PaymentOrder paymentOrder = this.paymentOrderMapper.getUserPaymentOrderByStatus(userId, PaymentStatusEnum.WAIT.getType());
        if (paymentOrder == null) {
            return;
        }
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        this.paymentOrderMapper.updateByPrimaryKey(paymentOrder);
        this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
    }
}

