/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.config.WithdrawConfig;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.proxy.WithdrawProxySerivce;
import com.bxm.localnews.payment.service.UserWithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WithdrawServiceImpl
extends BaseService
implements UserWithdrawService {
    @Autowired
    private WithdrawConfig withdrawConfig;
    @Autowired
    private WithdrawProperties withdrawProperties;
    @Autowired
    private WithdrawMapper withdrawMapper;
    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;
    @Autowired
    private WithdrawProxySerivce withdrawProxySerivce;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private BizLogService bizLogService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private PayProperties payProperties;

    @Override
    public Json<BigDecimal> userWithdraw(Long userId, BigDecimal amount, String equipment, String ip, Integer platform) {
        if (!this.withdrawProperties.getEnableSwitch().booleanValue()) {
            this.logger.warn("\u63d0\u73b0\u5f00\u5173\u672a\u5f00\u542f---\u4e0d\u5141\u8bb8\u63d0\u73b0");
            return ResultUtil.genFailedResult((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.logger.info("\u7528\u6237[{}]\u53d1\u8d77\u63d0\u73b0\uff0c\u91d1\u989d\u4e3a[{}]", (Object)userId, (Object)amount);
        Set<BigDecimal> withdrawSet = this.withdrawConfig.getWithdrawSet();
        if (!withdrawSet.contains(amount)) {
            this.logger.error("\u63d0\u73b0\u91d1\u989d\u5217\u8868[{}]\u4e0d\u5305\u542b\u91d1\u989d\u4e3a[{}]", (Object)JSON.toJSONString(withdrawSet), (Object)amount);
            return ResultUtil.genFailedResult((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        BigDecimal drawableCash = this.userAccountIntegrationService.getUserDrawableCash(userId);
        if (drawableCash.compareTo(amount) == -1) {
            this.logger.error("\u7528\u6237[{}]\u7684\u8d26\u6237\u4f59\u989d\u4e3a\uff1a[{}]\uff0c\u5c0f\u4e8e\u63d0\u73b0\u91d1\u989d[{}],\u4e0d\u5141\u8bb8\u63d0\u73b0", new Object[]{userId, drawableCash, amount});
            return ResultUtil.genFailedResult((String)"\u4f60\u7684\u8d26\u6237\u4f59\u989d\u4e0d\u8db3");
        }
        UserAuth userAuth = this.userAuthIntegrationService.selectUserAuthByUserId(userId);
        if (userAuth == null) {
            this.logger.error("\u7528\u6237[{}]\u672a\u7ed1\u5b9aopenId, \u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u8bf7\u91cd\u65b0\u767b\u9646\u540e\u518d\u5c1d\u8bd5\u63d0\u73b0");
        }
        WithdrawFlow lastWithdrawFlow = this.withdrawMapper.getUserLastWithdraw(userId);
        if (lastWithdrawFlow != null && !WithdrawEnum.SUCCESS_PAYMENT.getState().equals(lastWithdrawFlow.getState()) && !WithdrawEnum.FAIL_PAYMENT.getState().equals(lastWithdrawFlow.getState())) {
            this.logger.error("\u7528\u6237[{}]\u5df2\u5b58\u5728\u6b63\u5728\u63d0\u73b0\u7684\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)userId);
            return ResultUtil.genFailedResult((String)"\u4f60\u7684\u63d0\u73b0\u91d1\u989d\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u73b0");
        }
        String requestId = this.nextSequence().toString();
        if (this.distributedLock.lock(userId.toString(), requestId)) {
            BigDecimal limitAmount;
            Boolean isRisk = this.userIntegrationService.isRiskUser(userId);
            WithdrawFlow withdrawFlow = this.withDraw(userId, userAuth.getIdentifier(), amount, equipment, ip, isRisk, (byte)1);
            if (!isRisk.booleanValue() && amount.compareTo(limitAmount = new BigDecimal("2")) < 1) {
                withdrawFlow.setState(WithdrawEnum.DURING_PAYMENT.getState());
                this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
                String message = this.withdrawProxySerivce.withdraw(withdrawFlow);
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    return ResultUtil.genFailedResult((String)message);
                }
            }
            this.bizLogService.initiateWithdrawal(userId, amount, platform);
            this.distributedLock.unlock(userId.toString(), requestId);
            return ResultUtil.genSuccessResult((Object)amount);
        }
        return ResultUtil.genFailedResult((String)"\u4eca\u65e5\u7cfb\u7edf\u63d0\u73b0\u91d1\u989d\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
    }

    @Override
    public Message appletUserWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
        Message message = Message.build();
        if (!this.withdrawProperties.getEnableSwitch().booleanValue()) {
            this.logger.warn("\u63d0\u73b0\u5f00\u5173\u672a\u5f00\u542f---\u4e0d\u5141\u8bb8\u63d0\u73b0");
            return message.setSuccess(false).setMessage("\u4e0d\u5141\u8bb8\u63d0\u73b0");
        }
        this.logger.info("\u7528\u6237[{}]\uff0copenId: [{}]\u53d1\u8d77\u63d0\u73b0\uff0c\u91d1\u989d\u4e3a[{}]", new Object[]{userId, openId, amount});
        Double withdrawAmount = this.redisStringAdapter.increment(this.getWxMiniAppAmountKey(), amount.doubleValue());
        this.redisStringAdapter.expire(this.getWxMiniAppAmountKey(), (long)DateUtils.getCurSeconds());
        if (this.payProperties.getMiniAppLimitAmount().compareTo(BigDecimal.valueOf(withdrawAmount)) < 0) {
            return message.setSuccess(false).setMessage("\u4eca\u65e5\u5151\u6362\u5df2\u8fbe\u9650\u989d\uff0c\u8bf7\u660e\u65e5\u518d\u6765");
        }
        String requestId = this.nextSequence().toString();
        if (this.distributedLock.lock(userId.toString(), requestId)) {
            this.logger.debug("\u7528\u6237[{}]\u8fdb\u5165\u5fae\u4fe1\u63d0\u73b0\u8bf7\u6c42", (Object)userId);
            WithdrawFlow withdrawFlow = this.withDraw(userId, openId, amount, devcId, ip, false, (byte)2);
            withdrawFlow.setState(WithdrawEnum.DURING_PAYMENT.getState());
            this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
            String result = this.withdrawProxySerivce.withdraw(withdrawFlow);
            this.logger.debug("\u7528\u6237\u63d0\u73b0\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                return message.setSuccess(false).setMessage(result);
            }
            this.bizLogService.initiateWithdrawal(userId, amount, Integer.valueOf(5));
            this.distributedLock.unlock(userId.toString(), requestId);
            return message.setMessage(result);
        }
        this.logger.debug("\u7528\u6237[{}]\u672a\u80fd\u83b7\u53d6\u5230redis\u9501----\u76f4\u63a5\u8fd4\u56de\u4fe1\u606f", (Object)userId);
        return message.setSuccess(false).setMessage("\u4eca\u65e5\u5151\u6362\u5df2\u8fbe\u9650\u989d\uff0c\u8bf7\u660e\u65e5\u518d\u6765");
    }

    private WithdrawFlow withDraw(Long userId, String openId, BigDecimal amount, String equipment, String ip, Boolean isRisk, Byte withdrawType) {
        WithdrawFlow withdrawFlow = new WithdrawFlow();
        Long id = this.nextSequence();
        withdrawFlow.setId(id);
        withdrawFlow.setOrderNo(this.generateWithdrawNum());
        withdrawFlow.setPayChannel(this.getWithdrawChannel());
        withdrawFlow.setUserId(userId);
        withdrawFlow.setPayAccount(openId);
        withdrawFlow.setState(WithdrawEnum.AUDIT.getState());
        if (isRisk.booleanValue()) {
            withdrawFlow.setState(WithdrawEnum.DELAY_AUDIT.getState());
        }
        withdrawFlow.setAmount(amount);
        withdrawFlow.setClientIp(ip);
        withdrawFlow.setEquipment(equipment);
        Date now = new Date();
        withdrawFlow.setCreateTime(now);
        withdrawFlow.setUpdateTime(now);
        withdrawFlow.setWithdrawType(withdrawType);
        this.withdrawMapper.addWithdrawFlow(withdrawFlow);
        this.updateUserAccount(userId, amount, id);
        return withdrawFlow;
    }

    private void updateUserAccount(Long userId, BigDecimal award, Long relationId) {
        AccountCashParam accountCashParam = new AccountCashParam(userId, "DRAWABLEL_CASH", Boolean.FALSE, new BigDecimal("-" + award), relationId, "WECHAT_WITHDRAWAL", null);
        this.userAccountIntegrationService.addCash(accountCashParam);
    }

    private String generateWithdrawNum() {
        String prefix = WithdrawTypeEnum.getNameByType(WithdrawTypeEnum.WX_WITHDRAW.getType());
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private Long getWithdrawChannel() {
        return WithdrawTypeEnum.WX_WITHDRAW.getId();
    }

    private KeyGenerator getUserWithdrawKey(Long userId) {
        return RedisConfig.USER_WITHDRAW.copy().appendKey((Object)userId);
    }

    private KeyGenerator getWxMiniAppAmountKey() {
        return RedisConfig.WEIXIN_MINI_APP_AMOUNT.copy().appendKey((Object)"balance");
    }
}

