package com.bxm.localnews.payment.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhaoyadong 2019/1/2 17:54
 * @desc
 */
@Configuration
@EnableConfigurationProperties(AlipayProperties.class)
public class AliPayConfiguration {

    private AlipayProperties alipayProperties;

    public AliPayConfiguration(AlipayProperties alipayProperties) {
        this.alipayProperties = alipayProperties;
    }

    @Bean("alipayClient")

    public AlipayClient alipayClient() {
        AlipayClient alipayClient = new DefaultAlipayClient(alipayProperties.getGateWayUrl(), alipayProperties.getAppId(),
                alipayProperties.getRsaPrivateKey(), alipayProperties.getFormat(), alipayProperties.getCharset(),
                alipayProperties.getAlipayPublicKey(), alipayProperties.getSigntype());
        return alipayClient;
    }
}
