package com.bxm.localnews.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhaoyadong 2019/1/2 13:54
 * @desc
 */
@ConfigurationProperties("payment.ali.pay")
@Data
public class AlipayProperties {

    /**
     * appId
     */
    private String appId;

    /**
     * 支付宝网关
     */
    private String gateWayUrl;

    /**
     * 支付回调地址
     */
    private String notifyUrl;

    /**
     * 支付宝同步通知地址
     */
    private String returnUrl;

    /**
     * 私钥
     */
    private String rsaPrivateKey;

    /**
     * 公钥
     */
    private String alipayPublicKey;

    /**
     * 加密类型
     */
    private String signtype;

    /**
     * 编码
     */
    private String charset;

    /**
     * 返回格式
     */
    private String format;

    /**
     * 商品产品码
     */
    private String productCode;

    /**
     * 订单超时时间
     */
    private String timeoutExpress;

    /**
     * 是否开启回调验证
     */
    private boolean enableCallbackValid = false;
}
