package com.bxm.localnews.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/1/2 14:53
 * @desc
 */
@ConfigurationProperties("payment.pay")
@Component
@Data
public class PayProperties {

    /**
     * vip购买价格
     */
    private BigDecimal vipPrice;

    /**
     * 福利VIP会员卡支付价格
     */
    private BigDecimal welfareVipPrice;

    /**
     * vip标题
     */
    private String vipTitle;

    /**
     * vip描述
     */
    private String vipDesc;

    /**
     * 调试开关
     */
    private Boolean switchType = false;

    private BigDecimal miniAppLimitAmount;
}
