package com.bxm.localnews.payment.config;

import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.dto.WithdrawOptionDTO;
import com.google.common.collect.ImmutableList;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhaoyadong 2019/3/12 22:26
 * @desc
 */
@ConfigurationProperties("payment.withdraw")
@Component
@Data
public class WithdrawProperties {

    /**
     * 是否开启提现功能，关闭后所有用户均无法提现
     */
    private Boolean enableSwitch;

    /**
     * 红包活动统计
     */
    private String redPacketStatistics;

    /**
     * 配置的可提现列表
     */
    private List<WithdrawOptionDTO> withdrawOptions = ImmutableList.of(
            WithdrawOptionDTO.builder()
                    .withdrawId(1L)
                    .amount(new BigDecimal("10"))
                    .index(0)
                    .priority(0)
                    .stargy(WithdrwaStrategyEnum.ONCE.name())
                    .build(),
            WithdrawOptionDTO.builder()
                    .withdrawId(2L)
                    .amount(new BigDecimal("2"))
                    .index(0)
                    .priority(1)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build(),

            WithdrawOptionDTO.builder()
                    .withdrawId(3L)
                    .amount(new BigDecimal("15"))
                    .index(1)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build(),
            WithdrawOptionDTO.builder()
                    .withdrawId(4L)
                    .amount(new BigDecimal("30"))
                    .index(2)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build(),
            WithdrawOptionDTO.builder()
                    .withdrawId(5L)
                    .amount(new BigDecimal("50"))
                    .index(3)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build(),
            WithdrawOptionDTO.builder()
                    .withdrawId(6L)
                    .amount(new BigDecimal("100"))
                    .index(4)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build(),
            WithdrawOptionDTO.builder()
                    .withdrawId(7L)
                    .amount(new BigDecimal("200"))
                    .index(5)
                    .stargy(WithdrwaStrategyEnum.NORMAL.name())
                    .build()
    );
}
