package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 福利VIP卡的处理器
 * @author liujia
 * @date 2020/05/08 21:01
 */
@Slf4j
@Component
public class WelfareVipOrderProcesser implements OrderProcesser {

    private final PayProperties payProperties;

    private final UserIntegrationService userIntegrationService;

    @Autowired
    public WelfareVipOrderProcesser(PayProperties payProperties,
                                    UserIntegrationService userIntegrationService) {
        this.payProperties = payProperties;
        this.userIntegrationService = userIntegrationService;
    }

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.WELFARE_VIP;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return Message.build();
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        //todo ： 这里先暂时不做处理，目前只有一种VIP卡，后期多个的话这里需要处理
        return payProperties.getWelfareVipPrice();
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        log.debug("用户购买激活VIP，对应订单：{}", paymentOrder);

        //升级成为VIP以及给师傅发送相关推送等操作
        UserActivationVipFacadeParam param = new UserActivationVipFacadeParam();
        param.setChannel(paymentOrder.getChannel());
        param.setOrderId(paymentOrder.getId());
        param.setPlatformEnum(paymentOrder.getPlatform());
        param.setUserId(paymentOrder.getUserId());
        //这里默认给个1，暂时只有一种VIP卡类型，后期在进行拓展动态
        param.setVipCardId("1");

        return Message.build(userIntegrationService.activationVip(param));
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {

        return null;
    }
}
