package com.bxm.localnews.payment.pay;

import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;

/**
 * 支付
 * @author zhaoyadong 2019/1/2 14:08
 * @desc
 */
public interface PaymentOrderService extends PayService {

    /**
     * 更新支付订单状态
     * @param paymentOrder 支付订单详情
     * @return 更新结果
     */
    Message modifyStatus(PaymentOrder paymentOrder);

    /**
     * 更新支付订单信息
     * @param paymentOrder
     * @return
     */
    Message modifyPaymentOrderStatus(PaymentOrder paymentOrder);

    /**
     * 根据支付订单编号获取某一条支付订单的详细信息
     * @param paymentNum 支付订单编号
     * @return 支付订单详细信息
     */
    PaymentOrder getPaymentOrderByPaymentNo(String paymentNum);

    /**
     * 查询订单信息(主要是向微信查询订单信息)
     * @param paymentNum
     * @param payType
     * @return
     */
    OrderStatusDTO queryOrderStatus(String paymentNum, Byte payType);
}
