package com.bxm.localnews.payment.pay.impl;

import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.domain.UserPayorderRefundMapper;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.param.UserPayorderRefundBean;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 抽象的付款方式
 * @author liujia 2018/6/25 19:47
 */
public abstract class AbstractPayModeService implements PayModeService {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaymentOrderMapper paymentOrderMapper;
    @Autowired
    private UserPayorderRefundMapper userPayorderRefundMapper;
    @Autowired
    protected PaymentOrderService payService;
    @Resource
    private SequenceCreater sequenceCreater;

    /**
     * 将退款订单状态更新为已退款状态
     * @param refundOrderNo 退款订单编号
     * @param result        退款结果
     * @param status        更新状态
     */
    protected void changeRefundOrderStatus(String refundOrderNo,
                                           String refundTradeNo,
                                           String result,
                                           PaymentStatusEnum status) {
        userPayorderRefundMapper.updateByOrderNo(
                UserPayorderRefundBean.builder()
                        .refundOrderNo(refundOrderNo)
                        .refundTradeNo(refundTradeNo)
                        .result(result)
                        .status(status.getType())
                        .build());

        paymentOrderMapper.updateRefundOrder(refundTradeNo,status.getType());

    }
    /**
     * 在调用申请退款成功后，创建退款单
     * @param param         退款订单参数
     * @param refundOrderNo 退款订单编号
     * @param refundFee     退款订单金额
     */
    protected void createRefundOrder(PaymentRefundParam param,
                                     String refundOrderNo,
                                     BigDecimal refundFee) {

        UserPayorderRefundBean history = userPayorderRefundMapper.selectByOrderNo(refundOrderNo);
        //新增退款订单
        UserPayorderRefundBean refundBean = UserPayorderRefundBean.builder()
                .id(sequenceCreater.nextLongId())
                .createTime(new Date())
                .operatorId(param.getOperatorId())
                .orderId(param.getPayOrder().getId())
                .refundOrderNo(refundOrderNo)
                .refundFee(refundFee)
                .remark(param.getRemark())
                .status(PaymentStatusEnum.REFUNDING.getType())
                .build();

        if (null != history) {
            refundBean.setId(history.getId());
            refundBean.setResult("");
            refundBean.setCreateTime(null);

            userPayorderRefundMapper.updateByPrimaryKeySelective(refundBean);
        } else {
            userPayorderRefundMapper.insert(refundBean);
        }
        //更新订单状态
        paymentOrderMapper.updateRefundOrder(param.getPayOrder().getPaymentNum(),PaymentStatusEnum.REFUNDING.getType());

    }
    /**
     * 根据付款订单构建退款订单编号
     * @param param 退款订单创建参数
     * @return 退款订单编号
     */
    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getPaymentNum();
    }

}
