package com.bxm.localnews.payment.withdraw;

import com.bxm.localnews.payment.dto.WithdrawOptionDTO;
import com.bxm.localnews.payment.param.UserWithdrawParam;
import com.bxm.localnews.vo.UserAuth;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 提现上下文信息
 *
 * @author liujia
 * @date 2020/05/18 21:23
 */
@Data
public class WithdrawContext {
    /**
     * 原始的提现请求参数
     */
    private final UserWithdrawParam originParam;

    /**
     * 提现金额的选项，在 {@link com.bxm.localnews.payment.withdraw.filter.BaseWithdrawFilter}中设置
     */
    private WithdrawOptionDTO withdrawOption;

    /**
     * 兼容历史逻辑，提供提现金额直接写入
     */
    private BigDecimal amount;

    /**
     * 用户鉴权信息（微信oid），在 {@link com.bxm.localnews.payment.withdraw.filter.BindOidWithdrawFilter}中设置
     */
    private UserAuth userAuth;

    /**
     * 微信OID，兼容历史逻辑，如果未设置则从用户鉴权信息中获取
     */
    private String wechatOid;

    /**
     * 当前用户是否为风险用户，在 {@link com.bxm.localnews.payment.withdraw.filter.BaseWithdrawFilter}中设置
     */
    private boolean risk;

    /**
     * 提现记录ID
     */
    private Long withDrawId;

    public WithdrawContext(UserWithdrawParam originParam) {
        this.originParam = originParam;
    }

    public String getWechatOid() {
        if (null != wechatOid) {
            return wechatOid;
        }

        if (null != userAuth) {
            return userAuth.getIdentifier();
        }

        return null;
    }

    public BigDecimal getAmount() {
        if (null != amount) {
            return amount;
        }
        if (null == withdrawOption) {
            return BigDecimal.ZERO;
        }
        return withdrawOption.getAmount();
    }

    public Long getUserId() {
        return originParam.getUserId();
    }

    public UserWithdrawParam getOriginParam() {
        return originParam;
    }
}
