package com.bxm.localnews.payment.withdraw.filter;

import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 判断用户是否绑定了微信
 * @author liujia
 * @date 2020/05/18 21:51
 */
@Component
@Slf4j
public class BindOidWithdrawFilter extends AbstractWithdrawFilter {

    private final UserAuthIntegrationService userAuthIntegrationService;

    @Autowired
    public BindOidWithdrawFilter(UserAuthIntegrationService userAuthIntegrationService) {
        this.userAuthIntegrationService = userAuthIntegrationService;
    }

    @Override
    public Message run(WithdrawContext context) {
        if (context.getWechatOid() == null
                && context.getUserAuth() == null) {
            UserAuth userAuth = userAuthIntegrationService.selectUserAuthByUserId(context.getUserId());

            if (userAuth == null) {
                log.warn("用户[{}]未绑定openId, 不允许提现", context.getUserId());
                return Message.build(false, "请重新登陆后再尝试提现");
            }

            context.setUserAuth(userAuth);
        }
        return Message.build();
    }
}
