package com.bxm.localnews.quartz.facade.controller;


import com.alibaba.fastjson.JSON;
import com.bxm.localnews.quartz.param.InviteExpireTaskParam;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.PublishNewsBuildParam;
import com.bxm.localnews.quartz.param.PushMsgBuildParam;
import com.bxm.localnews.quartz.runtime.InviteRelationshipTask;
import com.bxm.localnews.quartz.runtime.NewsMonitorTask;
import com.bxm.localnews.quartz.runtime.PublishNewsTask;
import com.bxm.localnews.quartz.runtime.PushMessageTask;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-1", description = "定时任务构建相关服务接口")
@RestController
@RequestMapping("quartz")
public class QuartzManageController {

    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzManageController.class);

    private final ScheduleJobService scheduleJobService;

    @Autowired
    public QuartzManageController(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @ApiOperation(value = "1-1-1 构建新闻监控的定时任务", notes = "根据配置的监控条件构建持续执行的定时任务")
    @PostMapping("/add/monitor")
    public ResponseEntity<String> createMonitorTask(@RequestBody MonitorTaskBuildParam param) {
        NewsMonitorTask task = new NewsMonitorTask();
        task.setJobName(task.getJobName() + param.getIndexId());

        String cronExpression = "0 0 " + param.getFireTime() + " * * ?";

        LOGGER.debug("监控表达式：[{}]", cronExpression);

        task.setCron(cronExpression);
        task.addParam("parameter", param);

        Message message = scheduleJobService.addCronJob(task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-2 移除新闻监控的定时任务")
    @PostMapping("/remove/monitor")
    public ResponseEntity<String> removeMonitorTask(@RequestParam Long indexId) {
        NewsMonitorTask task = new NewsMonitorTask();
        Message message = scheduleJobService.remove(task.getJobName() + indexId, task.getGroup());

        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-3 添加新闻发布的定时任务（仅运行一次）", notes = "运营后台进行定时发布时调用")
    @PostMapping("/add/publish")
    public ResponseEntity<String> createPublishNewsTask(@RequestBody PublishNewsBuildParam param) {
        PublishNewsTask task = new PublishNewsTask();
        task.setJobName(task.getJobName() + "_" + param.getNewsId());
        task.addParam("parameter", param);
        task.setStartTime(param.getStartTime());

        if (scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            scheduleJobService.remove(task.getJobName(), task.getGroup());
        }
        LOGGER.warn(" 添加新闻发布的定时任务（仅运行一次）:{}", JSON.toJSONString(task));
        Message message = scheduleJobService.addSimpleJob(task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-4 添加消息推送的定时任务(仅运行一次)", notes = "运营后台配置了定时push时，进行定时推送")
    @PostMapping("/add/push")
    public ResponseEntity<String> createPushMsgTask(@RequestBody PushMsgBuildParam param) {
        PushMessageTask task = new PushMessageTask();
        task.setJobName(task.getJobName() + "_" + param.getMessageId());
        task.addParam("parameter", param);
        task.setStartTime(param.getStartTime());

        if (scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            scheduleJobService.remove(task.getJobName(), task.getGroup());
        }

        Message message = scheduleJobService.addSimpleJob(task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-5 移除推送的定时任务")
    @PostMapping("/remove/push")
    public ResponseEntity<String> removePushTask(Long messageId) {
        PushMessageTask task = new PushMessageTask();
        Message message = scheduleJobService.remove(task.getJobName() + "_" + messageId, task.getGroup());

        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-6 添加解除邀请关系的定时任务(仅运行一次)")
    @PostMapping("/add/invite")
    public ResponseEntity<String> createInviteTask(@RequestBody InviteExpireTaskParam param) {
        InviteRelationshipTask task = new InviteRelationshipTask();
        task.setJobName(task.getJobName() + "_" + param.getJobId());
        task.addParam("parameter", param);
        task.setStartTime(param.getStartTime());

        if (scheduleJobService.getJob(task.getJobName(), task.getGroup()) != null) {
            return ResponseEntity.ok().build();
        }

        Message message = scheduleJobService.addSimpleJob(task);
        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }

    @ApiOperation(value = "1-1-7 移除邀请的定时任务")
    @PostMapping("/remove/invite")
    public ResponseEntity<String> removeInviteTask(String jobId) {
        InviteRelationshipTask task = new InviteRelationshipTask();
        Message message = scheduleJobService.remove(task.getJobName() + "_" + jobId, task.getGroup());

        if (message.isSuccess()) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.badRequest().body(message.getLashMessaage());
        }
    }
}
