package com.bxm.localnews.quartz.facade;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.quartz.facade.fallback.PushMsgFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "localnews-msg", fallbackFactory = PushMsgFallbackFactory.class)
public interface PushMsgIntegService {


    @PostMapping("/push")
    void pushMsg(@RequestBody PushMessage message);

    @PostMapping("/push/interaction")
    void pushInteractionMessage();
}
