package com.bxm.localnews.quartz.facade;

import com.bxm.localnews.quartz.facade.fallback.NewsFallbackFactory;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.OptimizationNoticeParam;
import com.bxm.localnews.quartz.vo.CalculatePost;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = NewsFallbackFactory.class)
public interface NewsFeignService {

    @PostMapping("facade/news/quartz/news/monitor")
    ResponseEntity<Integer> countNews(@RequestBody MonitorTaskBuildParam monitorTaskBuildParam);

    @PostMapping("facade/news/quartz/myKind/sync")
    void syncMykindToData();

    @PostMapping("facade/news/quartz/marketingActivities/publish")
    void publishMarketingActivities();

    @PostMapping("facade/news/quartz/new/publish")
    void publishNews(@RequestParam("newsId") Long newsId);

    @PostMapping("facade/news/quartz/hotNews/expire")
    void checkHotNewsExpire();

    @PostMapping("facade/news/quartz/monitorStatus/update")
    void updateMonitorStatus(@RequestParam("id") Long id, @RequestParam("status") int status, @RequestParam("message") String message);

    @PostMapping("facade/news/reply/quartz/scanning")
    void updateNewsReplyStatus();

    @PostMapping("facade/news/quartz/calcParticipantsNum")
    void calcParticipantsNum();

    @PostMapping("/facade/mixRecommend/deleteExpiredMixRecommend")
    int deleteExpiredMixRecommend();

    @PostMapping("facade/news/quartz/addPostClick")
    void addPostClick(@RequestParam(value = "postId") Long postId, @RequestParam(value = "clickCount") Long clickCount);

    @PostMapping("/facade/post/statistic/refreshLikeInfo")
    void refreshLikeInfo();

    @PostMapping("/facade/post/statistic/calculatePostCount")
    CalculatePost calculatePostCount();

    @PostMapping("/facade/mixRecommend/optimizationNotice")
    Boolean optimizationNotice(@RequestBody OptimizationNoticeParam optimizationNoticeParam);


}
