package com.bxm.localnews.quartz.facade.fallback;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.facade.NewsFeignService;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.OptimizationNoticeParam;
import com.bxm.localnews.quartz.vo.CalculatePost;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class NewsFallbackFactory implements FallbackFactory<NewsFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PushMsgFallbackFactory.class);

    @Override
    public NewsFeignService create(Throwable throwable) {
        return new NewsFeignService() {
            @Override
            public ResponseEntity<Integer> countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
                return ResponseEntity.ok(0);
            }

            @Override
            public void syncMykindToData() {
                //记录请求参数
                LOGGER.error("syncMykindToData");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void publishMarketingActivities() {
                //记录请求参数
                LOGGER.error("publishMarketingActivities");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void publishNews(Long newsId) {
                //记录请求参数
                LOGGER.error("publishNews,参数:newsId{}",newsId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void checkHotNewsExpire() {
                //记录请求参数
                LOGGER.error("checkHotNewsExpire");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void updateMonitorStatus(Long id, int status, String message) {
                //记录请求参数
                LOGGER.error("updateMonitorStatus");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void updateNewsReplyStatus() {
                //记录请求参数
                LOGGER.error("updateNewsReplyStatus");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void calcParticipantsNum() {
                //记录请求参数
                LOGGER.error("calcParticipantsNum");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public int deleteExpiredMixRecommend() {
                LOGGER.error("deleteExpiredMixRecommend");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return 0;
            }

            @Override
            public void addPostClick(Long postId, Long clickCount) {
                //记录请求参数
                LOGGER.error("addPostClick");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void refreshLikeInfo() {
                //记录请求参数
                LOGGER.error("refreshLikeInfo");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public CalculatePost calculatePostCount() {
                LOGGER.error("calculatePostCount");
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public Boolean optimizationNotice(OptimizationNoticeParam optimizationNoticeParam) {
                LOGGER.error("OptimizationNotice,参数=[{}]" , JSONObject.toJSONString(optimizationNoticeParam));
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return false;
            }
        };
    }
}
