package com.bxm.localnews.quartz.facade.fallback;

import com.bxm.localnews.quartz.facade.UserAccountIntegService;
import com.bxm.localnews.quartz.param.AccountCashParam;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class UserAccountFallbackFactory implements FallbackFactory<UserAccountIntegService> {

    @Override
    public UserAccountIntegService create(Throwable throwable) {
        return new UserAccountIntegService() {
            @Override
            public ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param) {
                return ResponseEntity.ok(Boolean.FALSE);
            }
        };
    }
}
