package com.bxm.localnews.quartz.facade.fallback;

import com.bxm.localnews.quartz.facade.WithdrawFeignService;
import com.bxm.localnews.quartz.vo.WithdrawFlow;
import com.bxm.newidea.component.vo.Message;

import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/29 15:27
 * @desc
 */
@Component
public class WithdrawFallbackFactory implements FallbackFactory<WithdrawFeignService> {

    @Override
    public WithdrawFeignService create(Throwable throwable) {
        return new WithdrawFeignService() {
            @Override
            public ResponseEntity<Message> queryWithdraw(WithdrawFlow withdrawFlow) {
                return ResponseEntity.ok(Message.build(false));
            }
        };
    }
}
