package com.bxm.localnews.quartz.integration;

import com.bxm.localnews.quartz.facade.NewsFeignService;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.param.OptimizationNoticeParam;
import com.bxm.localnews.quartz.vo.CalculatePost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NewsIntegrationService {

    @Autowired
    NewsFeignService newsService;

    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        ResponseEntity<Integer> result = newsService.countNews(monitorTaskBuildParam);
        if (null == result) {
            return 0;
        }
        return result.getBody();

    }

    public void syncMykindToData() {
        newsService.syncMykindToData();
    }

    public void publishMarketingActivities() {
        newsService.publishMarketingActivities();
    }

    public void publishNews(Long newsId) {
        newsService.publishNews(newsId);
    }

    public void checkHotNewsExpire() {
        newsService.checkHotNewsExpire();
    }

    public void updateMonitorStatus(Long id, int status, String message) {
        newsService.updateMonitorStatus(id, status, message);
    }

    public void updateNewsReplyStatus(){
        newsService.updateNewsReplyStatus();
    }

    public void calcParticipantsNum() {
        newsService.calcParticipantsNum();
    }

    public void addPostClick(Long postId, Long clickCount) {
        newsService.addPostClick(postId, clickCount);
    }

    public CalculatePost getCalculatePost() {
        return newsService.calculatePostCount();
    }

    public Boolean sendOptimizationNotice(OptimizationNoticeParam parameter) {
        return newsService.optimizationNotice(parameter);
    }

}
