package com.bxm.localnews.quartz.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.message.constant.MessageEnum;
import com.bxm.localnews.message.dto.PushPayloadInfo;
import com.bxm.localnews.message.service.PushMessageService;
import com.bxm.localnews.quartz.domain.NewsQuartzMapper;
import com.bxm.localnews.quartz.service.NewsQuartzService;
import com.bxm.localnews.quartz.vo.NewsSearchWordBean;
import com.bxm.localnews.quartz.vo.RecommendNewsBean;
import com.bxm.newidea.component.tools.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class NewsQuartzServiceImpl implements NewsQuartzService {

    private static final Logger logger = LoggerFactory.getLogger(NewsQuartzServiceImpl.class);

    private static String url = "http://top.baidu.com/buzz?b=1&fr=topindex";

    private static String userAgent = "User-Agent";

    private static String value = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36";

    private NewsQuartzMapper newsQuartzMapper;

    private PushMessageService pushMessageService;

    @Autowired
    public NewsQuartzServiceImpl(NewsQuartzMapper newsQuartzMapper, PushMessageService pushMessageService) {
        this.newsQuartzMapper = newsQuartzMapper;
        this.pushMessageService = pushMessageService;
    }

    private List<NewsSearchWordBean> loadHotword() {
        List<NewsSearchWordBean> list = new ArrayList<>();
        try {
            Document doc = Jsoup.connect(url).header(userAgent, value).timeout(5000).get();
            Elements elements = doc.select(".keyword");
            for (Element e : elements) {
                if (e == null) {
                    continue;
                }
                Element ee = e.lastElementSibling();
                String name = e.select("a:eq(0)").text();
                String number = ee.select("span").text();
                NewsSearchWordBean word = new NewsSearchWordBean();
                word.setName(name);
                word.setNumber(Integer.valueOf(number));
                list.add(word);
                if (list.size() >= 10) {
                    break;
                }
            }
        } catch (Exception e) {
            logger.error("---抓取热点新闻标题异常---");
        }
        return list;
    }

    @Override
    public void createHotword() {
        List<NewsSearchWordBean> searchWords = loadHotword();
        if (searchWords.size() > 8) {
            newsQuartzMapper.delete();
            newsQuartzMapper.insertBatch(searchWords);
        }
    }

    @Override
    public void execWakeup() {
        List<RecommendNewsBean> newsList = this.newsQuartzMapper.noticeRecommendNewsList();
        for (RecommendNewsBean news : newsList) {
            this.pushNews(news);
        }
    }

    /**
     * 将推送的新闻推送给用户
     * @param news 推荐新闻（包含用户信息）
     */
    private void pushNews(RecommendNewsBean news) {
        PushPayloadInfo info = PushPayloadInfo.build(MessageEnum.NEWS);
        info.addExtend("newsId", news.getId() + "");
        info.addExtend("title", news.getTitle());
        info.addExtend("isRecommendNews", 2);
        info.addExtend("type", news.getType());

        if (!StringUtils.isEmpty(news.getImgUrl())) {
            List<String> imgs = JSON.parseArray(news.getImgUrl(), String.class);
            if (imgs.size() > 0) {
                info.addExtend("img", imgs.get(0));
            }
        }
        this.pushMessageService.pushMsgByAlias(null, news.getTitle(), news.getUserId() + "", info);
    }

}
