package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.quartz.domain.QuartzLogMapper;
import com.bxm.localnews.quartz.service.QuartzLogService;
import com.bxm.localnews.quartz.vo.QuartzLogBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class QuartzLogServiceImpl implements QuartzLogService {

    private static final Logger logger = LoggerFactory.getLogger(QuartzLogServiceImpl.class);

    private QuartzLogMapper quartzLogMapper;

    @Autowired
    public QuartzLogServiceImpl(QuartzLogMapper quartzLogMapper) {
        this.quartzLogMapper = quartzLogMapper;
    }

    @Override
    public int save(QuartzLogBean quartzLogBean) {
        return this.quartzLogMapper.insert(quartzLogBean);
    }

}