package com.bxm.localnews.quartz.service.impl;

import java.util.List;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.quartz.domain.UserKindMapper;
import com.bxm.localnews.quartz.service.NewsKindQuartzService;
import com.bxm.localnews.quartz.vo.NewsKind;
import com.bxm.localnews.quartz.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/11/12 20:36
 * @desc
 */
@Service
public class NewsKindQuartzServiceImpl extends BaseService implements NewsKindQuartzService {

    private RedisHashMapAdapter redisHashMapAdapter;

    private RedisSetAdapter redisSetAdapter;

    private UserKindMapper userKindMapper;

    private Long limit = 5000L;

    @Autowired
    public NewsKindQuartzServiceImpl(RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter,
                                     UserKindMapper userKindMapper) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.userKindMapper = userKindMapper;
    }

    @Override
    public void syncMykindToData() {
        List<Long> userIds = redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, limit, Long.class);
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>() {
        };
        userIds.forEach(userId -> {
            List<NewsKind> newsKindList = redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
            if (CollectionUtils.isNotEmpty(newsKindList)) {
                this.userKindMapper.deleteByUserId(userId);

                List<UserKind> userKindList = Lists.newArrayList();
                int i = 0;
                for (NewsKind newsKind : newsKindList) {
                    UserKind userKind = new UserKind();
                    userKind.setUserId(userId);
                    userKind.setKindId(newsKind.getId());
                    userKind.setSortNo(i);
                    userKindList.add(userKind);
                    i++;
                }

                this.userKindMapper.batchInsert(userKindList);
            }
        });

        if (redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0) {
            syncMykindToData();
        }
    }
}
