package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.quartz.domain.PayFlowQuartzMapper;
import com.bxm.localnews.quartz.service.AbstractSplitTablePerMonthService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

public class PayFlowSplitTableServiceImpl extends AbstractSplitTablePerMonthService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PayFlowSplitTableServiceImpl.class);

    private static final String DEFAULT_TABLE_NAME = "a_pay_flow";

    private PayFlowQuartzMapper payFlowQuartzMapper;

    @Autowired
    public PayFlowSplitTableServiceImpl(PayFlowQuartzMapper payFlowQuartzMapper) {
        this.payFlowQuartzMapper = payFlowQuartzMapper;
    }

    @Override
    protected String getDefaultTableName() {
        return DEFAULT_TABLE_NAME;
    }

    @Override
    protected Map<String, Object> loadTableStatus(String tableName) {
        return this.payFlowQuartzMapper.loadTableStatus(tableName);
    }

    @Override
    protected void createTable(String nextTableName, long autoIncrement) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("nextTableName", nextTableName);
        data.put("autoIncrement", autoIncrement);
        this.payFlowQuartzMapper.createTable(data);
    }

    @Override
    protected void alterTableIncrement(String tableName, long autoIncrement) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("tableName", tableName);
        data.put("autoIncrement", autoIncrement);
        this.payFlowQuartzMapper.alterTableIncrement(data);
    }

}
