package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.quartz.domain.QuartzMapper;
import com.bxm.localnews.quartz.service.QuartzService;
import com.bxm.localnews.quartz.vo.QuartzLogBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class QuartzServiceImpl implements QuartzService {

    private static final Logger logger = LoggerFactory.getLogger(QuartzServiceImpl.class);

    private QuartzMapper quartzMapper;

    @Autowired
    public QuartzServiceImpl(QuartzMapper quartzMapper) {
        this.quartzMapper = quartzMapper;
    }

    @Override
    public int save(QuartzLogBean quartzLogBean) {
        return this.quartzMapper.insert(quartzLogBean);
    }

}