package com.bxm.localnews.quartz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.quartz.domain.VideoBlackMapper;
import com.bxm.localnews.quartz.service.VideoBlackService;
import com.bxm.localnews.quartz.vo.VideoBlack;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class VideoBlackServiceImpl extends BaseService implements VideoBlackService {

    @Autowired
    private VideoBlackMapper videoBlackMapper;

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public void videoBlackConsume() {
        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoBlackQueue");
        VideoBlack videoBlack = redisListAdapter.rightPop(keyGenerator, VideoBlack.class);
        if (null != videoBlack) {
            videoBlack.setId(nextSequence());
            videoBlack.setAddTime(new Date());
            videoBlackMapper.insertSelective(videoBlack);
        }
    }
}
