/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.quartz.domain.UserKindMapper;
import com.bxm.localnews.quartz.service.NewsKindQuartzService;
import com.bxm.localnews.quartz.vo.NewsKind;
import com.bxm.localnews.quartz.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsKindQuartzServiceImpl
extends BaseService
implements NewsKindQuartzService {
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisSetAdapter redisSetAdapter;
    private UserKindMapper userKindMapper;
    private Long limit = 5000L;

    @Autowired
    public NewsKindQuartzServiceImpl(RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, UserKindMapper userKindMapper) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.userKindMapper = userKindMapper;
    }

    @Override
    public void syncMykindToData() {
        List userIds = this.redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, this.limit, Long.class);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>(){};
        userIds.forEach(arg_0 -> this.lambda$syncMykindToData$0((TypeReference)typeReference, arg_0));
        if (this.redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0L) {
            this.syncMykindToData();
        }
    }

    private /* synthetic */ void lambda$syncMykindToData$0(TypeReference typeReference, Long userId) {
        List newsKindList = (List)this.redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
        if (CollectionUtils.isNotEmpty((Collection)newsKindList)) {
            this.userKindMapper.deleteByUserId(userId);
            ArrayList userKindList = Lists.newArrayList();
            int i = 0;
            for (NewsKind newsKind : newsKindList) {
                UserKind userKind = new UserKind();
                userKind.setUserId(userId);
                userKind.setKindId(newsKind.getId());
                userKind.setSortNo(Integer.valueOf(i));
                userKindList.add(userKind);
                ++i;
            }
            this.userKindMapper.batchInsert((List)userKindList);
        }
    }
}

