/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PushMessageEnum;
import com.bxm.localnews.message.dto.PushMessage;
import com.bxm.localnews.message.dto.PushPayloadInfo;
import com.bxm.localnews.message.service.PushMsgSupplyService;
import com.bxm.localnews.quartz.domain.NewsQuartzMapper;
import com.bxm.localnews.quartz.service.NewsQuartzService;
import com.bxm.localnews.quartz.vo.NewsSearchWordBean;
import com.bxm.localnews.quartz.vo.RecommendNewsBean;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsQuartzServiceImpl
implements NewsQuartzService {
    private static final Logger logger = LoggerFactory.getLogger(NewsQuartzServiceImpl.class);
    private static String url = "http://top.baidu.com/buzz?b=1&fr=topindex";
    private static String userAgent = "User-Agent";
    private static String value = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36";
    private NewsQuartzMapper newsQuartzMapper;
    private PushMsgSupplyService pushMsgSupplyService;

    @Autowired
    public NewsQuartzServiceImpl(NewsQuartzMapper newsQuartzMapper, PushMsgSupplyService pushMsgSupplyService) {
        this.newsQuartzMapper = newsQuartzMapper;
        this.pushMsgSupplyService = pushMsgSupplyService;
    }

    private List<NewsSearchWordBean> loadHotword() {
        ArrayList<NewsSearchWordBean> list = new ArrayList<NewsSearchWordBean>();
        try {
            Document doc = Jsoup.connect((String)url).header(userAgent, value).timeout(5000).get();
            Elements elements = doc.select(".keyword");
            for (Element e : elements) {
                if (e == null) continue;
                Element ee = e.lastElementSibling();
                String name = e.select("a:eq(0)").text();
                String number = ee.select("span").text();
                NewsSearchWordBean word = new NewsSearchWordBean();
                word.setName(name);
                word.setNumber(Integer.valueOf(number));
                list.add(word);
                if (list.size() < 10) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("---\u6293\u53d6\u70ed\u70b9\u65b0\u95fb\u6807\u9898\u5f02\u5e38---");
        }
        return list;
    }

    @Override
    public void createHotword() {
        List<NewsSearchWordBean> searchWords = this.loadHotword();
        if (searchWords.size() > 8) {
            this.newsQuartzMapper.delete();
            this.newsQuartzMapper.insertBatch(searchWords);
        }
    }

    @Override
    public void execWakeup() {
        List newsList = this.newsQuartzMapper.noticeRecommendNewsList();
        for (RecommendNewsBean news : newsList) {
            this.pushNews(news);
        }
    }

    private void pushNews(RecommendNewsBean news) {
        List imgs;
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.NEWS);
        info.addExtend("newsId", (Object)(news.getId() + ""));
        info.addExtend("title", (Object)news.getTitle());
        info.addExtend("isRecommendNews", (Object)2);
        info.addExtend("type", (Object)news.getType());
        if (!StringUtils.isEmpty((CharSequence)news.getImgUrl()) && (imgs = JSON.parseArray((String)news.getImgUrl(), String.class)).size() > 0) {
            info.addExtend("img", imgs.get(0));
        }
        PushMessage pushMessage = PushMessage.build(null, (String)news.getTitle()).setUserId(news.getUserId() + "").setPayloadInfo(info);
        this.pushMsgSupplyService.pushMsg(pushMessage);
    }
}

