package com.bxm.newidea.controller;

import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.service.RecommendService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("api/video")
public class VideoController {


    private RecommendService recommendService;

    @Autowired
    public VideoController(RecommendService recommendService){
        this.recommendService = recommendService;
    }

    @ApiOperation(value = "视频推荐接口", httpMethod = "GET", notes = "给业务系统调用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", required = true),
    })
    @SuppressWarnings("unchecked")
    @GetMapping(value = "recommendList")
    public ResponseEntity<List<VideoDto>> recommendList(@RequestParam("userId")Long userId,
                                                        @RequestParam("pageSize")Integer pageSize){
        List<VideoDto> list = recommendService.recommend(userId,pageSize);
        return new ResponseEntity(list, HttpStatus.OK);
    }

}
