package com.bxm.newidea.domain;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface LocalnewsRecommendedMapper {
    /**
     * 给用户推荐首页本地新闻
     *
     * @param userId        用户id
     * @param areaCode      地区编码
     * @param localNewsSize 新闻数量
     * @return 本地新闻列表
     */
    List<Long> recommendLocalnewsOfIndex(@Param("userId") Long userId,
                                         @Param("areaCode") String areaCode,
                                         @Param("province") Long province,
                                         @Param("localNewsSize") Integer localNewsSize);

    /**
     * 给用户推荐本地新闻
     *
     * @param userId        用户id
     * @param areaCode      地区编码
     * @param localNewsSize 新闻数量
     * @return 本地新闻列表
     */
    List<Long> recommendLocalnews(@Param("userId") Long userId,
                                  @Param("areaCode") String areaCode,
                                  @Param("province") Long province,
                                  @Param("localNewsSize") Integer localNewsSize);
}
