package com.bxm.newidea.domain;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.param.NewsRecommendParam;
import com.bxm.newidea.vo.News;
import com.bxm.newidea.vo.NewsVO;

@Mapper
public interface NewsMapper {

    News selectByPrimaryKey(Long id);

    List<News> recommendNews(NewsRecommendParam param);

    List<News> recommendOtherNews(NewsRecommendParam param);

    List<News> recommendNewsWithoutTime(NewsRecommendParam param);

    List<News> recommendOtherNewsWithoutTime(NewsRecommendParam param);

    List<News> firstRecommendNews(NewsRecommendParam param);

    List<News> queryRecommendNewsList(@Param("newsId") Long newsId, @Param("pageSize") int pageSize,
                                      @Param("userId") Long userId);

    List<News> queryRecommendNewsListWithoutTime(@Param("newsId") Long newsId, @Param("pageSize") int pageSize,
                                      @Param("userId") Long userId);

    List<News> queryVideoList(NewsRecommendParam param);

    List<News> getTops(@Param("limit") int limit, @Param("areaCode") String areaCode);

    NewsVO getById(@Param("id") Long id, @Param("userId") Long userId);

    News selectWithoutContentByPrimaryKey(Long id);

}
