package com.bxm.newidea.domain;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.vo.ForumRecommend;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * <p>
 * 帖子信息表 Mapper 接口
 * </p>
 *
 * @author JandMin
 * @since 2019-04-03
 */
@Mapper
@Repository
public interface ForumPostMapper {

    /**
     * 查询帖子列表
     * @date: 2019/4/4
     * @param param
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     * @throws
     */
    List<ForumRecommend> findForumPostList(ForumQueryParam param);

    List<ForumRecommend> findRecommendForumPost(@Param("areaCode") String areaCode,@Param("size") int size);

    /**
     * 根据帖子的标签查询相关推荐
     * @date: 2019/4/4
     * @param postId
     * @param size
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     * @throws
     */
    List<Map<String,Object>> findForumPostByTag(@Param("postId") Long postId,
                                                @Param("size")int size,
                                                @Param("areaCode")String areaCode);

    List<Long> selectRecentlyPostList(@Param("recentlyTime") Date recentlyTime,
                                      @Param("areaCode") String areaCode);

    List<Long> selectFixPostList(@Param("pageSize") Integer pageSize,
                                 @Param("areaCode") String areaCode);

}
