package com.bxm.newidea.domain;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Mapper
@Repository
public interface LocalnewsRecommendedMapper {
    /**
     * 给用户推荐首页本地新闻
     *
     * @param userId        用户id
     * @param areaCode      地区编码
     * @param localNewsSize 新闻数量
     * @return 本地新闻列表
     */
    List<Long> recommendLocalnewsOfIndex(@Param("userId") Long userId,
                                         @Param("areaCode") String areaCode,
                                         @Param("province") Long province,
                                         @Param("localNewsSize") Integer localNewsSize);

    /**
     * 给用户推荐本地新闻
     *
     * @param userId        用户id
     * @param areaCode      地区编码
     * @param localNewsSize 新闻数量
     * @return 本地新闻列表
     */
    List<Long> recommendLocalnews(@Param("userId") Long userId,
                                  @Param("areaCode") String areaCode,
                                  @Param("province") Long province,
                                  @Param("localNewsSize") Integer localNewsSize);

    /**
     * 根据帖子的标签获取相关本地新闻
     * @date: 2019/4/8
     * @param areaCode 地区编码
     * @param postId
     * @param province
     * @param userId 用户id
     * @param size 新闻数量
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     * @throws 
     */
    List<Map<String,Object>> findNewsByForumTag(@Param("areaCode")String areaCode,
                                                @Param("postId")Long postId,
                                                @Param("province")Long province,
                                                @Param("userId")Long userId,
                                                @Param("size") Integer size);

}
